@echo off
chcp 65001 >nul
:: ===============================================================
:: SuporTech(C) DiskTools
:: Licenciado sob Creative Commons Attribution-ShareAlike 4.0
:: Desenvolvido por SuporTech - https://suportech.com.br
:: Todas as saídas dos comandos são salvas em %LOGFILE%
:: ===============================================================
color 1E

set "LOGFILE=%~dp0sptdisktool.log"
set "TIMESTAMP=%DATE% %TIME%"
set "EMAIL=%EMAIL%"

rem ========== CAPTURA DE INFO DO SISTEMA ==========
for /f "tokens=2 delims=:" %%A in ('ipconfig ^| findstr /c:"IPv4"') do set "IP=%%A"
for /f "tokens=2 delims=:" %%A in ('getmac /fo table /nh ^| findstr /i "Transport Name"') do set "MAC=%%A"
set "USER=%USERNAME%"
set "HOST=%COMPUTERNAME%"
set "OSVERSION="
ver > nul 2>nul && ver | findstr /i "Microsoft Windows" > tempver.txt
for /f "tokens=* delims=" %%A in (tempver.txt) do set "OSVERSION=%%A"
del tempver.txt >nul 2>&1

rem ========== INÍCIO DO LOG ==========

echo ==================================================== >> "%LOGFILE%"
echo INÍCIO: %TIMESTAMP% >> "%LOGFILE%"
echo Usuário..........: %USER% >> "%LOGFILE%"
echo Computador.......: %HOST% >> "%LOGFILE%"
echo IP...............: %IP% >> "%LOGFILE%"
echo MAC Address......: %MAC% >> "%LOGFILE%"
echo Sistema..........: %OSVERSION% >> "%LOGFILE%"
echo E-mail Suporte...: %EMAIL% >> "%LOGFILE%"
echo ---------------------------------------------------- >> "%LOGFILE%"
echo.




:menu
echo ===============================================================
echo              SuporTech(C) DiskTools - MENU PRINCIPAL
echo ===============================================================
echo.
echo  1. Listar Discos (list disk)
echo  2. Selecionar Disco
echo  3. Criar Partição Primária
echo  4. Formatar Partição como NTFS
echo  5. Atribuir Letra à Partição
echo  6. Tornar Partição Ativa
echo  7. Listar Volumes
echo  0. Sair
echo ===============================================================
echo.

set /p opcao=Escolha uma opção (0-7): 


if "%opcao%"=="1" goto list_disk
if "%opcao%"=="2" goto select_disk
if "%opcao%"=="3" goto create_partition
if "%opcao%"=="4" goto format_partition
if "%opcao%"=="5" goto assign_letter
if "%opcao%"=="6" goto set_active
if "%opcao%"=="7" goto list_volume
if "%opcao%"=="0" goto sair
goto menu

:list_disk
echo [%DATE% %TIME%] list disk >> %LOGFILE%
echo list disk | diskpart >> %LOGFILE%
echo list disk | diskpart
pause
goto menu

:select_disk
set /p num=Informe o número do disco (ex: 2): 
echo [%DATE% %TIME%] select disk %num% >> %LOGFILE%
echo select disk %num% | diskpart >> %LOGFILE%
echo select disk %num% | diskpart
pause
goto menu

:create_partition
echo [%DATE% %TIME%] create partition primary >> %LOGFILE%
(
echo select disk 2
echo create partition primary
) | diskpart >> %LOGFILE%
(
echo select disk 2
echo create partition primary
) | diskpart
pause
goto menu

:format_partition
echo [%DATE% %TIME%] format fs=ntfs quick >> %LOGFILE%
(
echo select partition 1
echo format fs=ntfs quick
) | diskpart >> %LOGFILE%
(
echo select partition 1
echo format fs=ntfs quick
) | diskpart
pause
goto menu

:assign_letter
set /p letra=Digite a letra que deseja atribuir (ex: E): 
echo [%DATE% %TIME%] assign letter=%letra% >> %LOGFILE%
(
echo select partition 1
echo assign letter=%letra%
) | diskpart >> %LOGFILE%
(
echo select partition 1
echo assign letter=%letra%
) | diskpart
pause
goto menu

:set_active
echo [%DATE% %TIME%] active >> %LOGFILE%
(
echo select partition 1
echo active
) | diskpart >> %LOGFILE%
(
echo select partition 1
echo active
) | diskpart
pause
goto menu

:list_volume
echo [%DATE% %TIME%] list volume >> %LOGFILE%
echo list volume | diskpart >> %LOGFILE%
echo list volume | diskpart
pause
goto menu

:sair
echo Obrigado por usar o SuporTech(C) DiskTools!
echo [%DATE% %TIME%] Encerrando sessão >> %LOGFILE%
timeout /t 2 >nul
exit